/*************************************************************************
 * DISCLAIMER                                                            *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*******************************************************************
  Copyright (c) 2011 Freescale Semiconductor
  \file     	Main.c
  \brief    	Smart Card Reader for MC9S08JM60
  \author   	Freescale Semiconductor
  \version    0.1
  \date     	15/Aug/2011
*********************************************************************/

#ifndef __SMARTCARD
#define __SMARTCARD

/* Includes */
#include "derivative.h"     /* include peripheral declarations */

/* Definitions */
#define SC_POWER          PTGD_PTGD0
#define SC_RESET          PTED_PTED3
#define SC_PRESENCE       PTGD_PTGD1
#define SC_PRESENCE_PE    PTGPE_PTGPE1
#define SC_CARD_INSERTED  0
#define SC_NO_CARD        1

#define SC_POWER_DD       PTGDD_PTGDD0
#define SC_RESET_DD       PTEDD_PTEDD3
#define SC_PRESENCE_DD    PTGDD_PTGDD1

#define SC_POWER_ON       0
#define SC_POWER_OFF      0

#define SC_RESET_HIGH     1
#define SC_RESET_LOW      0

#define SC_SUCCESS        0
#define SC_ERROR          1

#define SC_CMD_IDLE       0
#define SC_CMD_RECEIVED   1

#define SC_RxD_Timeout word 0x1000

extern byte sc_cmd_status;
extern byte sc_cmd_buffer[64];
extern byte sc_resp_buffer[64];

void SC_Init(void);
void SC_Start(void);
byte SC_servo(void);


#endif




